-- Selection Dialog Generator
require( "scripts/style.lua" );

-- Include the static data definitions
NameFont = {
  standardFont,
  24,
  BlackColor
};

HeaderFont = {
  standardFont,
  48,
  BlackColor
};

Line1Font = {
  "fonts/monotype_corsiva.mvec",
  34,
  BlackColor
};

Line2Font = {
  "fonts/monotype_corsiva.mvec",
  24,
  BlackColor
};

ButtonX = 127;
ButtonY = 111;
ButtonYSpace = 34;
Groupgap = 134;
ButtonXGap = 200;

TelephoneButtonGraphics = {
	"assets/buttons/telephone_btn_idle",
	"assets/buttons/telephone_btn_down",
	"assets/buttons/telephone_btn_hl",
	"assets/buttons/telephone_btn_down",
};	

SelButtonGraphics = {
	"assets/images/down",
	"assets/images/down",
	"assets/images/down",
	"assets/images/down"
};

SelStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = SelButtonGraphics,
	sound = kDefaultButtonSound
};

-- Make the selection dialog
MakeDialog
{
	Bitmap
	{ 
		image="images/wedding panning/planner_bg",
		x=kCenter,
		y=kCenter,
		
		SelectionDialog
		{
			x = 0, y = 0, w=kMax, h=kMax,
				
			Text
			{
				font = Line1Font,
				name = "line1",
				x=0,y=10,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "selectionDialog"
			};
			Text
			{
				font = Line2Font,
				name = "line2",
				x=0,y=65,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "selectionDialog2"
			};
		
			SetStyle(SelStyle);
			BeginGroup();
			Button{
				name="button11",
				--label="selection11",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*0),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    Select(1,1);
					end
			};
			
			Button{
				name="button12",
				--label="selection12",
				x=ButtonX+ButtonXGap,
				y=ButtonY+(ButtonYSpace*0),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    Select(1,2);
					end
			};
			
			Button{
				name="button13",
				--label="selection13",
				x=ButtonX+ButtonXGap+ButtonXGap,
				y=ButtonY+(ButtonYSpace*0),
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    Select(1,3);
					end
			};
			
			BeginGroup();
			Button{
				name="button21",
				--label="selection21",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*0)+Groupgap,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    Select(2,1);
					end
			};
			
			Button{
				name="button22",
				--label="selection22",
				x=ButtonX+ButtonXGap,
				y=ButtonY+(ButtonYSpace*0)+Groupgap,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    Select(2,2);
					end
			};
			
			Button{
				name="button23",
				--label="selection23",
				x=ButtonX+ButtonXGap+ButtonXGap,
				y=ButtonY+(ButtonYSpace*0)+Groupgap,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    Select(2,3);
					end
			};
			
			BeginGroup();
			Button{
				name="button31",
				--label="selection31",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*0)+Groupgap+Groupgap,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    Select(3,1);
					end
			};
			Button{
				name="button32",
				--label="selection32",
				x=ButtonX+ButtonXGap,
				y=ButtonY+(ButtonYSpace*0)+Groupgap+Groupgap,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
			    command = 
					function()
					    Select(3,2);
					end
			};
			Button{
				name="button33",
				--label="selection33",
				x=ButtonX+ButtonXGap+ButtonXGap,
				y=ButtonY+(ButtonYSpace*0)+Groupgap+Groupgap,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
					    Select(3,3);
					end
			};
			
			
			SetStyle(DefaultStyle);
			
			Button{
				x = 800, -- hide the ok button initially
				y = 600,
				font = StandardButtonFont,
				graphics = TelephoneButtonGraphics,
				name="chooseok",
				label="telephonebutton",
				type = kPush,
				rolloversound = "assets/audio/sfx/phone_button_01.ogg",
				sound = "assets/audio/sfx/phone_button_02.ogg",
				command = 
					function()
						PlaceOrder();
					end
				
			};
			
		}
	}
}